﻿/** townnews-plug-in.jsx 11/20/2019, 8:38:17 PM **/
/** townnews-plug-in.jsx 10/24/2019, 2:13:07 PM **/
/** townnews-plug-in.jsx 9/13/2019, 1:19:52 PM **/
/** townnews-plug-in.jsx 7/31/2019, 10:51:12 AM **/
/** townnews-plug-in.jsx 7/21/2019, 3:15:14 PM **/
/** townnews-plug-in.jsx 7/16/2019, 1:11:06 PM **/
/** townnews-plug-in.jsx 7/11/2019, 1:58:25 PM **/
/** townnews-plug-in.jsx 7/9/2019, 4:19:06 PM **/
/** townnews-plug-in.jsx 7/2/2019, 5:00:32 PM **/
/** townnews-plug-in.jsx 6/25/2019, 11:39:43 AM **/
/** townnews-plug-in.jsx 6/11/2019, 9:55:55 AM **/
/** townnews-plug-in.jsx 5/23/2019, 8:35:26 AM **/
/** townnews-plug-in.jsx 5/7/2019, 10:33:48 AM **/
/** townnews-plug-in.jsx 5/6/2019, 12:27:23 PM **/
/** townnews-plug-in.jsx 4/26/2019, 2:29:05 PM **/
/** townnews-plug-in.jsx 4/25/2019, 9:03:52 AM **/
//-----------------------------------------------------------------------------
// cSpell: ignore siteid
// cSpell: ignoreRegExp /\([a-z]+(\d)*\)/i
//-----------------------------------------------------------------------------
//-- The SANDBOX is here. Please shower off outside. 
//-----------------------------------------------------------------------------
$.level = 0;
#targetengine 'com.townnews.BLOXTotalCMS';



//-----------------------------------------------------------------------------
//-- R E V I S I O N   H I S T O R Y
//-----------------------------------------------------------------------------

//-- 

//-- 5.41.05.2019.11.12
//--	no ticket, add namings for CC 2020

//-- 5.41.03.2019.10.24
//--	INDESIGN-2647 add lazyLoad_b value when calling 'loginAndSetupMenusAndEvents'

//-- 5.39.04.2019.09.13
//--	Code Cleanup

//-- 5.38.06.2019.07.31
//--	Modified 'nameWithoutExtension' to include option for ALL extensions

//-- 5.38.03.2019.07.21
//--	INDESIGN-2595 alter 'handleError' to use $ versions of dialogs set to 469 pixels wide
//-- 5.38.01.2019.07.11-16
//--	INDESIGN-2586 work on relaunch while debugging

//-- 5.37.11.2019.07.09
//--	INDESIGN-2585 add a unique host for CS 5.5

//-- 5.37.10.2019.07.02
//--	no ticket, adding some test code for keeping logged in while debugging

//-- 5.37.06.2019.06.11
//--	INDESIGN-1941 modify clearing of existing variables during launch for use with running ExtendScript Debugger
//--	INDESIGN-1941 Provide a way to identify which file errored when loading.

//-- 5.36.25.2019.05.06
//--	INDESIGN-2547 change way root script function works because of a change to our development method. Users should notice no difference.

//-- 5.36.23.2019.04.11
//--	Renaming the function to unzip the framework files

//-- 5.36.22.2019.04.02
//--	no ticket Swap order of Appliance OS and Client software versions

//-- 5.36.06.2019.02.12
//--	INDESIGN-2143 modifications to 'handleError' to include the client version in the error message logged (dialog shows it from ui.jsx)

//-- 5.35.03.2018.12.17
//--	minor change to loading JSX in development environment

//-- 5.34.04.2018.11.01
//--	INDESIGN-2344, add the version information for CC 2019

//-- 5.33.09.2018.10.09
//--	INDESIGN-2363 Add ability to no decompress MacOS framework file

//-- 5.32.26.2018.08.03
//--	INDESIGN-2243 add a global property for General_Documents so that it can be used during the login process to locate the Active Version, NextVersion, PreviousVersion folders

//-- 5.32.19.2018.07.10 
//--	INDESIGN-2273 sort the PDFs shown in Settings and Support

//-- 5.32.07.2018.06.04
//--	INDESIGN-2229 build the Add-Ons directory

//-- 5.30.01.2018.03.27
//--	INDESIGN-232 add a appDisplayName

//-- 5.29.01.2018.03.17-19
//--	INDESIGN-2108 Remove hard coded setting for forceCrossPlatformLinks
//--	INDESIGN-2110 Support using a MacOS_homeFolder.enabled file

//-- 5.26.02.2018.02.02
//--	INDESIGN-2047 define the user agent string

//-- 5.21.04.2017.10.02-3
//--	no ticket, pushed the global av into the global host
//--	INDESIGN-1912 add host.st2 and .st3 (.st4 and .st5 are set elsewhere) for troubleshooting purposes

//-- 5.21.03.2017.09.29
//--	INDESIGN-1911 CS 5.5 setting wrong version

//-- 5.21.01.2017.09.22
//--	no ticket, add the code version, and build to the errors

//-- 5.20.32.2017.09.07
//--	Add ability to scale images with ScriptUI .onDraw override

//-- 5.20.31.2017.09.05-6
//--	Adding the ability to see the errors in this.com.townnews.BLOXTotalCMS.localError
//--	INDESIGN-1821 fixing login issues with CS5 and MacOS

//-- 5.20.10.2017.07.06 
//--	INDESIGN-1821, provide a warning for unupdated versions of Adobe InDesign CS 5.5 

//-- 5.20.03.2017.06.21
//--	INDESIGN-850 add a host property for noIconButtonTitles

//-- 5.19.05.2017.03.21
//--	INDESIGN-1678 include the build number in Handle Error

//-- 5.18.01-1.2017.02.15
//--	INDESIGN-1566 allow code to launch from "tcms_indesign_client" or "test_client" in debug mode

//-- 5.17.04.2017.01.09
//--	INDESIGN-1560 adding another internal host flag for CC 2017 or newer

//-- 5.16.11.2016.12.39
//--	INDESIGN-1548 add warnings about unsupported builds of the Adobe Products

//-- 5.16.06.2016.12.02
//--	INDESIGN-1522 Add Client software Build Numbers 

//-- 5.16.03.2016.11.18
//--	INDESIGN-1503 change the login procedure on MacOS to always place the framework on the local workstation until version 5.18.

//-- 5.16.02.2016.11.17
//--	INDESIGN-1301 decompress the .zip file to the correct folder

//-- 5.15.39.2016.11.08
//--	INDESIGN-1301 Change the method of loading the framework and dll files

//-- 5.14.67.2016.10.04
//--	INDESIGN-1263 add the btc logo back to the dialogs

//-- 5.14.26.2016.09.22
//--	More changes to support knowing the host information. In this case if the windows host is 32 or 64 bit as it determines which DLL to load. 

//-- 5.14.52.2016.09.07 in Baton Rouge, LA
//--	INDESIGN-1230 disable Ad Owl and Ad Market

//-- 5.15.24.2016.09.02
//--	INDESIGN-1071 Adding code to load the CURL lib

//-- 5.14.23.2016.05.17
//--	Estimated more CC versions

//-- 5.13.03.2016.02.02 
//--	INDESIGN-923 loading a PDF preset for PageTrackerPreview

//-- 5.12.67.2016.01.13
//--	INDESIGN-877 change the regular expression used to determine the name of the code folder

//-- 5.12.57.2015.12.23 (Hi Jessica)
//--	INDESIGN-866 Record the active version.
//--	INDESIGN-868 Record the activeClientFolderName.txt
//--	Removed legacy CVS comments.

//-- 5.12.20.2015.07.27
//--	INDESIGN-622, if login fails, then don't log that all was well.

//-- 5.12.12.2015.06.17
//--	Adding support for new CC 2015 versions

//-- 5.10.04.2015.01.26-28
//--	Adding Windows 7 and XP tests to facilitate finding protectiveShutdownLog files. INDESIGN-155
//--	Adding Adobe InDesign 6.1 or 8.1 support to the mix.

//-- 5.06.04.2014.09.26
//--	Add text for CC 2014 version number of 10.0, 10.1, 10.2, and 11.0

//-- 4.72.50.2014.02.03
//--	Change the behavior of the General Documents folder

//-- 4.72.43.2014.01.20
//--	Update array with CS versions to handle future upgrades

//-- 4.71.95e.2014.01.10
//--	Revising host information indicated below. Errors in Tucson with length

//-- 4.71.93c.2013.11.14
//--	Adding a host info for revision files that is shorter

//-- 4.72.01.2013.09.12
//--	The handle Error function now shows the version number in non-Continue errors.

//-- 4.71.90e.2013.08.26 in Tucson, AZ
//--	Update the APP Version number support to handle creative cloud updates. 

//-- 4.71.67.2013.07.10 in Tucson, AZ
//--	Use a CC version of the JSON class

//-- 4.71.56.2013.06.11
//--	In the 'handleError' function we are now sending along the error text to use in the file name of the server version of the error log.

//-- 4.71.52.2013.06.06
//--	In addition to writing .version files. Also going to write .application files to aid with the determination of the sorting of log files. 

//-- 4.71.38.2013.05.14
//--	Allowing the machine login name to fail silently

//-- 4.71.32.2013.04.25
//--	Forcing error handler to disable redraw

//-- 4.71.27.2013.04.17
//--	adding new global flag for CS 5 for hiding progress bars.

//-- 4.71.05.2013.03.11
//--	Reading the .enabled and .disabled files

//-- 4.70.20, 2013.01.25
//-- 	Removed hard coded 'exportInlineNotes'

//-- 4.70.15, 2013.01.18
//--	Adding a version number to the Error Handler screen for when sites only send screen dumps.

//-- 4.70.10, 2013.01.03
//--	Modifying code to skip . files when using 'getFilesWithSuffix' 

//-- 4.69.29, 2012.10.20
//--	Adding functionality to the Handle Error code to support tossing along the log registration

//-- 4.69.06, 2012.09.17
//--	More Ad Owl logging and error checking. 

//-- 4.69.05, 2012.09.17
//--	Allowing Standalone Ad Owl to place files into the user hive. 
//--	Cleanup the CVS versioning information in this file

//-- 4.68.04, 2012.08.28
//--	More login checking

//-- 4.66.15, 2012.06.26
//--	Adding support for Ad Owl logo

//-- 4.66.12, 2012.06.21
//--	Corrected two dialog typos

//-- 4.66.05, 2012.06.08
//--	Changing the version file to include a file extension of .version so that the CVS will stop asking about it.

//-- 4.66.04, 2012.06.07
//--	Pushing the global object onto the app for access.

//-- 4.65.25, 2012.05.30
//--	Adding stand alone ad owl support (well improveing it)

//-- 4.65.01, 2012.04.26
//--	 First version with support for AdOwl



//-----------------------------------------------------------------------------
//-- C O P Y R I G H T   A N D   L I C E N S I N G
//-----------------------------------------------------------------------------
//--
//-- Copyright © 2019, TownNews
//--
//-- Redistribution of this source code must retain the above copyright 
//--	notice, and the accompanying conditions and legal disclaimer. 
//--
//-- Redistributions in all forms (binary, printed, audio, video, etc.) 
//--	must reproduce the above copyright notice, these conditions, and 
//--	the below disclaimer in all forms provided with the distributions. 
//--
//-- electronic publishing support does not endorse or promote products
//--	derived from this software without specific prior permission
//--	in writing. 
//--
//-- This software is provided by the copyright holders and contributors 
//--		"As is" and any express or implied warranties, including, but not 
//--		limited to, the implied warranties of merchantability and fitness 
//--		for a particular purpose are disclaimed. In no event shall the 
//--		regents or contributors be liable for any direct, indirect, 
//--		incidental, special, exemplary, or consequential damages 
//--		(including, but not limited to, procurement of substitute goods 
//--		or services; loss of use, data, or profits; or business 
//--		interruption) however caused and on any theory of liability, 
//--		whether in contract, strict liability, or tort (including 
//--		negligence or otherwise) arising in any way out of the use of 
//--		this software, even if advised of the possibility of such damage.
//--
//-----------------------------------------------------------------------------


//-- Purpose: to load the appropriate compiled and non-compiled resources 
//--	which allow the BLOX Total CMS Plug-In to operate. After loading, 
//--	this calls the key launch sequence items, requests login, and if
//--	login isn't an option, then will uninstall all visible features.
//
//-----------------------------------------------------------------------------
//-- Note, the following is a method which much be defined prior to its use.
//
//
File.prototype.nameWithoutExtension = function (pullAllExtensions_b) {

	//-------------------------------------------------------------------------
	//-- N A M E   W I T H O U T   E X T E N S I O N
	//-------------------------------------------------------------------------
	//-- Generic: Yes for ExtendScript. Not JavaScript.
	//-------------------------------------------------------------------------
	//-- Purpose: to return the name of the file without the file extension.
	//-------------------------------------------------------------------------
	//-- Arguments: None. It is a method.
	//-------------------------------------------------------------------------
	//-- Calls: Nothing.
	//-------------------------------------------------------------------------
	//-- Returns: The name without the extension or the original name if no
	//--		file extension is used. 
	//-------------------------------------------------------------------------
	//-- Sample Use: 
	//~ 	var fileRef = File.saveDialog ('Pick an Adobe InDesign File', '*.indd' ) ;
	//~ 	var baseName = fileRef.nameWithoutExtension() ;
	//-------------------------------------------------------------------------
	//-- Written: 2009.09.21 by Jon S. Winters of electronic publishing support
	//-- eps@electronicpublishingsupport.com
	//-------------------------------------------------------------------------	

	//-- Get the original name ;
	var fullName = this.name;
	var finalDotPosition_i = 0;

	//-- Locate the final position of the final . before the extension.
	//-- 5.36.38.2019.07.31 INDESIGN-1935 adding new option to strip off all
	//-- dot (.) patterns which might be stacked extensions
	if (pullAllExtensions_b === true) {
		finalDotPosition_i = fullName.indexOf(".");
	} else {
		finalDotPosition_i = fullName.lastIndexOf(".");
	}
	//-- check that position. If it isn't -1 (missing) return the text
	//--		up to that position. 
	//-- Note, there are some odd things that can happen when passing
	//--		a file reference that begins with a single dot. Be wary. 
	if (finalDotPosition_i > -1) {
		return fullName.substr(0, finalDotPosition_i);
	}
	//-- implied else, return the original name because there is no dot.
	return fullName;
}
//
//
Folder.prototype.getFilesWithSuffix = function (includeFilesWithThisSuffix) {

	//-------------------------------------------------------------------------
	//-- G E T   F I L E S   W I T H   S U F F I X
	//-------------------------------------------------------------------------
	//-- Generic: Yes!
	//-------------------------------------------------------------------------
	//-- Purpose: To create a folder based search method for files containing
	//--	suffixes that works on both Windows and Mac OS. Windows searching
	//--	works fairly easily, Mac OS X not so nice with ExtendScript. This
	//--	provides a generic method for handling files with suffixes. 
	//-------------------------------------------------------------------------
	//-- Arguments: 
	//--	includeFilesWithThisSuffix: a STRING for the suffix
	//-------------------------------------------------------------------------
	//-- Calls: Mac OS calls an internal function.
	//-------------------------------------------------------------------------
	//-- Returns: an array of FILE objects. 
	//--	Or an empty array if nothing is returned.
	//-------------------------------------------------------------------------
	//-- Sample Use: var images = (Folder.desktop).getFilesWithSuffix ('.jpg')
	//-------------------------------------------------------------------------
	//-- Notes: Do not send it an * or other wild card. Mac OS could return
	//--	files with the suffix not at the end. 
	//-------------------------------------------------------------------------
	//-- Written: 2011.06.17 by Jon S. Winters of TownNews
	//-- (c) 2017 TownNews All rights reserved
	//-------------------------------------------------------------------------

	//-- 4.70.10, 2012.01.03, make sure there are no . files
	var ra = new Array();
	var allFilesWithSuffix = this.getFiles('*' + includeFilesWithThisSuffix);
	//-- make sure there was something found. The loop doesn't run if the length is zero
	for (var fi = 0; fi < allFilesWithSuffix.length; fi++) {
		if (allFilesWithSuffix[ fi ].name.substr(0, 1) != '.') {
			ra.push(allFilesWithSuffix[ fi ]);
		}
	}
	return ra;
}
//
//
Folder.prototype.verify = function () {

	//-------------------------------------------------------------------------
	//-- V E R I F Y
	//-------------------------------------------------------------------------
	//-- Generic: Yes
	//-------------------------------------------------------------------------
	//-- Purpose: A folder object method to verify if the folder specified
	//--		actually exists. If the folder doesn't exist, the method will
	//--		attempt to create it. 
	//-------------------------------------------------------------------------
	//-- Returns: True if the folder exists, false if it couldn't create it.
	//-------------------------------------------------------------------------
	//-- Sample Call: 
	//--		Folder ( '~/IsItHere' ).verify() ;
	//-------------------------------------------------------------------------
	//-- Calls: Nothing
	//-------------------------------------------------------------------------
	//-- Written 2009.09.19 on board US Airways flight 4376.
	//-- eps@electronicpublishingsupport.com
	//-------------------------------------------------------------------------	

	if (this.exists) {
		return true;
	}
	else {
		//-- Create an array like a stack of folders that will need
		//--		to be created.
		var foldersToCreate = new Array();
		//-- Create a local copy of the original folder
		//--		because it needs to be modified within
		//--		this routine.
		//--		Using the absoluteURI version of the name to point
		//--			all the way through to the sever. Only this version
		//--			of the activeFolder needs to use this absoluteURI
		//--			notation because.
		var activeFolder = new Folder(this.absoluteURI);

		//-- Loop through the path structure until every part of
		//--		of the folder path is checked. Any non-existent 
		//--		folder path will be added to the array to create.
		while (!activeFolder.exists) {
			//-- 4.39.15, have noticed or a long time that if
			//--	the .path is not good that it will generate a path
			//--	to one of the scripting folders. 
			if (activeFolder.path == '') {
				return false;
			}
			//-- Add the activeFolder to the array of folders to create
			foldersToCreate.push(activeFolder);
			//-- Now get to the parent of the folder. 
			//--		Can't use .parent because if the active folder
			//--			doesn't exist, it won't have a parent.
			activeFolder = new Folder(activeFolder.path);
		}
		//-- At this point we have an array of folders that need to be 
		//--		created. The array will have one element too many because
		//--		of the final line of the 
		while (foldersToCreate.length > 0) {
			//-- Remove the last item added to the array of folders to create
			activeFolder = foldersToCreate.pop();
			//-- Try to create this folder
			if (!activeFolder.create()) {
				return false;
			} //-- end of if create
		} //-- end of lower while
	} //-- end of else from way up top
	//-- At this point the folder has to exist else we already returned false
	return true;
}
//
//
Image.prototype.onDraw = function () {

	//-------------------------------------------------------------------------
	//-- S C R I P T   U I   O V E R R I D E   O N   D R A W   --   S C A L E
	//-------------------------------------------------------------------------
	//-- Purpose: To cause images in script UI dialogs to scale DOWN to fit
	//--	their container. 
	//-------------------------------------------------------------------------
	//-- Originally written by Marc Autret, found in ScriptUI for Dummies
	//--	modified for 5.20.32 by Jon S. Winters on 2017.09.07
	//-------------------------------------------------------------------------


	var err;
	var k_n;
	var localError;
	var containerWidthHeight_a = [];
	var imageWidthHeight_a = [];
	var xy_a = [];

	try {
		if (!this.image) {
			return;
		}
		//-- get the size of the container and the size of the image
		//--	These are arrays
		containerWidthHeight_a = this.size;
		imageWidthHeight_a = this.image.size;

		//-- find the best scale to use with no enlargements.
		k_n = Math.min(containerWidthHeight_a[ 0 ] / imageWidthHeight_a[ 0 ], containerWidthHeight_a[ 1 ] / imageWidthHeight_a[ 1 ], 1);

		//-- Calculate the scale Resize proportionally:
		imageWidthHeight_a = [ k_n * imageWidthHeight_a[ 0 ], k_n * imageWidthHeight_a[ 1 ] ];

		//-- Calculate the position of the center 
		xy_a = [ (containerWidthHeight_a[ 0 ] - imageWidthHeight_a[ 0 ]) / 2, (containerWidthHeight_a[ 1 ] - imageWidthHeight_a[ 1 ]) / 2 ];

		//-- now redraw it at the potentially new size, but in the 
		//--	middle of the image's frame
		this.graphics.drawImage(this.image, xy_a[ 0 ], xy_a[ 1 ], imageWidthHeight_a[ 0 ], imageWidthHeight_a[ 1 ]);

		//-- clear out the three arrays
		containerWidthHeight_a = imageWidthHeight_a = xy_a = null;
	}
	catch (err) {
		localError = err;
		$.bp(true);
	}
}
//
//-----------------------------------------------------------------------------

//-- MAIN BODY -- not a function call. This must be this way to load the
//--	functions in the jsx and jsxbin files into the global namespace.
try {
	var err;
	//-- 5.37.06.2019.06.11 INDESIGN-1941 to allow the new ExtendScript
	//-- debugger to properly function correctly, we should NOT keep
	//--	any prior cached items. These should all be replaced.
	//-- 5.37.06.2019.06.11 INDESIGN-1941 check to see if there are 
	//--	global objects from a prior running in debugger
	//-- 5.38.01.2019.07.11 INDESIGN-2586 add more options

	if ($.level && this.hasOwnProperty('com') &&
		this.com.hasOwnProperty('townnews') &&
		this.com.townnews.hasOwnProperty('BLOXTotalCMS') &&
		this.com.townnews.BLOXTotalCMS.hasOwnProperty('tncms') &&
		this.com.townnews.BLOXTotalCMS.tncms.hasOwnProperty('loggedIn') &&
		(this.com.townnews.BLOXTotalCMS.tncms.loggedIn === true) &&
		this.com.townnews.BLOXTotalCMS.hasOwnProperty('servers') &&
		this.com.townnews.BLOXTotalCMS.servers.hasOwnProperty('activeSite') &&
		isNonEmptyString(this.com.townnews.BLOXTotalCMS.servers.activeSite)) {

		this.debug_o = new Object();
		this.debug_o.serverName_s = this.com.townnews.BLOXTotalCMS.tncms.serverName;
		this.debug_o.userName_s = this.com.townnews.BLOXTotalCMS.tncms.userName;
		this.debug_o.passwordEncoded_s = this.com.townnews.BLOXTotalCMS.tncms.password;
		//-- substr pulls of a slash
		this.debug_o.site_s = this.com.townnews.BLOXTotalCMS.tncms.currentSite.siteName.substr(1);
		//-- 5.38.01.2019.07.11 INDESIGN-1586 store the naming convention 
		//--	and the development mode
		if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('namingConventionDetails')) {
			this.debug_o.namingConventionDetails_o = this.com.townnews.BLOXTotalCMS.namingConventionDetails;
		}
		if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('developmentModeActive')) {
			//force a Boolean
			this.debug_o.developmentModeActive_b = !!this.com.townnews.BLOXTotalCMS.developmentModeActive;
			// $.bp(this.debug_o.developmentModeActive_b);
		}
	}
	delete this._TranslateMenu;
	delete this.activeDialog;
	delete this.BLOXTotalCMS;
	delete this.com;
	delete this.JSON;
	delete this.tncms;

	this.com = new Object();
	this.com.townnews = new Object();
	this.com.townnews.BLOXTotalCMS = new Object();


	//-- 4.66.04, 2012.06.07, add the global object onto the app itself.
	//-- 5.37.06.2019.06.11 INDESIGN-1941, if we aren't in debug mode,
	//--	don't replicate this object. This MIGHT cause issues
	if ($.level) {
		BLOXTotalCMS = this.com.townnews.BLOXTotalCMS;
	}
	//-- All of this needs to remain text. This is just programmer information.
	//--	but it does show up in the About dialog.
	this.com.townnews.BLOXTotalCMS.scriptName = 'BLOX Total CMS';

	/*
	##     ## ######## ########   ######  ####  #######  ##    ##
	##     ## ##       ##     ## ##    ##  ##  ##     ## ###   ##
	##     ## ##       ##     ## ##        ##  ##     ## ####  ##
	##     ## ######   ########   ######   ##  ##     ## ## ## ##
	 ##   ##  ##       ##   ##         ##  ##  ##     ## ##  ####
	  ## ##   ##       ##    ##  ##    ##  ##  ##     ## ##   ###
	   ###    ######## ##     ##  ######  ####  #######  ##    ##
	*/

	//-- Script Version Number -- to be maintained by the script writer/editor
	this.com.townnews.BLOXTotalCMS.scriptEditDate = "2019.11.21";
	this.com.townnews.BLOXTotalCMS.scriptVersion = "5.41.06";
	this.com.townnews.BLOXTotalCMS.scriptBuildNumber = "1";
	//------------------------------------------------------------------

	//-- 5.14.52.2016.09.07 INDESIGN-1230 disable these options as part
	//--	of the effort to remove these options completely
	//~ this.com.townnews.BLOXTotalCMS.AdMarketStandAlone = false ;
	//~ this.com.townnews.BLOXTotalCMS.AdOwlStandAlone = false ;

	//-- 5.29.01.2018.03.19 INDESIGN-2108 Remove hard coded setting
	//~ this.com.townnews.BLOXTotalCMS.forceCrossPlatformLinks = false ;

	//------------------------------------------------------------------

	//-- 5.16.06.2016.12.02 INDESIGN-1522 make a new combined variable
	//--	with the build number included.
	this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild = this.com.townnews.BLOXTotalCMS.scriptVersion + '-' + this.com.townnews.BLOXTotalCMS.scriptBuildNumber;


	//------------------------------------
	//-- H O S T   I N F O R M A T I O N
	//------------------------------------


	//--	being used and what operating system is in use. This is overkill, but
	//--	it provides all possible information before the 'includes'.
	this.com.townnews.BLOXTotalCMS.host = new Object();
	//-- Version 3.91 revised version tracking again.

	//-- 4.71.52.2013.06.06 add a clean name of the host
	this.com.townnews.BLOXTotalCMS.host.appCleanName = app.name.replace(new RegExp('[\\W\\.]', 'g'), '_');

	//-- 5.30.01.2018.03.27 INDESIGN-232 add a Display name for the host
	this.com.townnews.BLOXTotalCMS.host.appDisplayName = app.name.replace(new RegExp('[\\W\\.]', 'g'), ' ');

	//-- 4.42.01 -- Bug in the original version code
	//-- 4.71.90e.2013.08.26 in Tucson, AZ Support upgraded versions of
	//--	Creative Cloud
	//-- 4.72.43.2014.01.20 Support upgraded versions of Creative Cloud
	//--	as Adobe Recently released CC 9.2.x
	//-- 5.06.04.2014.09.26 set the CC 2014 version number correctly. Add 
	//--	support for expected updates.
	try {
		//-- 5.10.04.2015.01.28 INDESIGN-396 include CS 6.1 as an update for CS 6
		//-- 5.12.12.2015.06.17 Add more CC versions. 
		//-- 5.15.24.2016.09.02 Add more CC version for 2014 and 2015
		//-- 5.15.39.2016.11.04 Support change to 2017 CC. Was expecting 2016
		//-- 5.20.10.2017.07.06 INDESIGN-1821 add warnings for non-upgraded CS5
		//-- 5.20.31.2017.09.06 INDESIGN-1821 Convert the property names to 
		//--	strings because the dotted numbers weren't working. 
		//-- 5.34.04.2018.11.01 INDESIGN-2344 add support for CC 2019
		//-- 5.38.01.2019.07.16 INDESIGN-2586 add a few future versions for
		//--	the sites that don't update the clients regularly
		//-- 5.41.05.2019.11.12 Update to list Creative Cloud 2020
		this.com.townnews.BLOXTotalCMS.host.versionObject = { "60": 'CS 4', "70": 'CS 5', "75": 'CS 5.5', "75.0": 'CS 5.5.0', "75.1": 'CS 5.5.1', "75.2": 'CS 5.5.2', "75.3": 'CS 5.5.3', "80": 'CS 6', "81": 'CS 6', "82": 'CS 6', "90": 'CC', "91": 'CC.1', "92": 'CC.2', "93": 'CC.3', "94": 'CC.4', "100": 'CC 2014', "101": 'CC 2014.1', "102": 'CC 2014.2', "103": 'CC 2014.3', "104": 'CC 2014.4', "110": 'CC 2015', "111": 'CC 2015.1', "112": 'CC 2015.2', "113": 'CC 2015.3', "114": 'CC 2015.4', "115": 'CC 2015.5', " 116": 'CC 2015.6', "120": 'CC 2017.0', "121": 'CC 2017.1', "122": 'CC 2017.2', "123": 'CC 2017.3', "130": 'CC 2018.0', "131": 'CC 2018.1', "140": 'CC 2019.0', "141": 'CC 2019.1', "142": 'CC 2019.2', "150": 'CC 2020', "151": 'CC 2020.1', "152": 'CC 2020.2', "160": 'CC version not known', "170": 'CC version not known' };

		//-- 5.16.11.2016.12.30 INDESIGN-1548 the method broke after reaching
		//--	CC 2014 because the digits switched to 2 from one. 
		//-- 5.20.31.2017.09.06 INDESIGN-1821 force this to a string.
		//-- 5.20.34.2018.09.11 INDESIGN-850 now we need 
		//--	both a string and a number version
		this.com.townnews.BLOXTotalCMS.host.av = app.version;
		this.com.townnews.BLOXTotalCMS.host.versionPointer_n = this.com.townnews.BLOXTotalCMS.host.av.substr(0, this.com.townnews.BLOXTotalCMS.host.av.indexOf('.', String(Math.floor(this.com.townnews.BLOXTotalCMS.host.av.substr(0, this.com.townnews.BLOXTotalCMS.host.av.indexOf('.') + 1))).length + 1)) * 10;
		this.com.townnews.BLOXTotalCMS.host.versionPointer_s = String(this.com.townnews.BLOXTotalCMS.host.versionPointer_n);

		//-- 5.20.10.2017.07.06 INDESIGN-1821, provide a warning for unupdated
		//--	versions of Adobe InDesign CS 5.5
		//-- 5.21.03.2017.09.29 trying a different formula
		//~ 		if (this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "75") {
		if (this.com.townnews.BLOXTotalCMS.host.versionPointer_s.indexOf('75') == 0) {
			this.com.townnews.BLOXTotalCMS.host.versionPointer_s = String(this.com.townnews.BLOXTotalCMS.host.versionPointer_n + '.' + String(this.com.townnews.BLOXTotalCMS.host.av).split('.')[ 2 ]);
			//-- 5.20.34.2018.09.11 INDESIGN-850 make the numeric version
			this.com.townnews.BLOXTotalCMS.host.versionPointer_n = Number(this.com.townnews.BLOXTotalCMS.host.versionPointer_s);
			//-- 5.20.10.2017.07.06 INDESIGN-1821 if we are here, then this is
			//--	definitely a CS 5 version. The if later will accept this 
			//--	as a result. 
			this.com.townnews.BLOXTotalCMS.host.isCS5 = true;
			//-- 5.37.11.2019.07.09 INDESIGN-2585 add extra tag for CS 5.5
			//--	because we need it to locate the keyboard shortcuts 
			//--	and some other user settings
			this.com.townnews.BLOXTotalCMS.host.isCS_5_5 = true;
		}
		//
		this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion = this.com.townnews.BLOXTotalCMS.host.versionObject[ this.com.townnews.BLOXTotalCMS.host.versionPointer_s ];

		if (this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion == undefined) {
			throw "Array doesn't contain the proper number for this version: '" + this.com.townnews.BLOXTotalCMS.host.versionPointer_s + "'";
		}
	}
	catch (err) {
		this.com.townnews.BLOXTotalCMS.localError = err;
		$.bp(true);
		this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion = 'CC+';
	}
	//-- 5.16.11.2016.12.30 INDESIGN-1548 setup a warning about bad versions
	this.com.townnews.BLOXTotalCMS.host.unsupportedVersions = new Object();

	with (this.com.townnews.BLOXTotalCMS.host) {
		//-- CS 4
		unsupportedVersions[ "60" ] = [ 'This version of the ' + app.name + ' software is too old.', 'It is not supported by the BLOX Total CMS client.', 'You must upgrade.', 'Creative Cloud is needed to support all features.' ];
		//-- 
		//-- CS 5.5 but not the unupdated versions
		unsupportedVersions[ "75.0" ] = unsupportedVersions[ "75.1" ] = unsupportedVersions[ "75.2" ] = [ 'This version of the ' + app.name + ' software NEEDS to be updated.', 'The only stable version of CS 5.5 is the final update known has 7.5.3.', 'In addition, Adobe no longer provides any support for Creative Suite CS 5 nor CS 5.5.', 'The Creative Cloud version of ' + app.name + ' is needed to support all BLOX Total CMS features.' ];
		//-- Original CS 6
		unsupportedVersions[ "80" ] = [ 'This is an UN-updated version of ' + app.name + ' CS 6.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the free CS 6.1 or subscribe to Adobe Creative Cloud.', 'Adobe Creative Cloud is needed to support all features.' ];
		//-- Broke versions of CC 2015
		unsupportedVersions[ "114" ] = [ app.name + ' Creative Cloud 2015 versions .4 and .5 are not supported by BLOX Total CMS.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the current version of Creative Cloud.' ];
		unsupportedVersions[ "115" ] = [ app.name + ' Creative Cloud 2015 versions .4 and .5 are not supported by BLOX Total CMS.', 'It is known to be buggy and prone to crashing.', 'Please upgrade to the current version of Creative Cloud.' ];

		//-- 5.20.03.2017.06.21 no ticket. Also warn about the .1 version 
		//--	being prone to crashing during quitting
		unsupportedVersions[ "121" ] = [ app.name + ' Creative Cloud 2017 versions .1 are not recommended.', 'It is known to be prone to crashing when quitting.', 'Please downgrade to the original version of Creative Cloud 2017 or upgrade to something newer than .1 if it exists.' ];
	}
	//-- 4.71.26.2013.04.17 adding new flag for CS 5 for hiding progress bars.
	//-- 5.10.04.2015.01.28 INDESIGN-396 CS 5.5 should also be considered a CS 5 version.
	//-- 5.20.31.2017.09.06 INDESIGN-1821 CS 5.5 isn't getting pulled here
	//--	Change the formula for determining what is what.
	//-- 5.20.34.2018.09.11 INDESIGN-850 have this use the string versionPointer
	this.com.townnews.BLOXTotalCMS.host.isCS5 = this.com.townnews.BLOXTotalCMS.host.isCS5 || (this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion.indexOf('CS 5') > -1) || (this.com.townnews.BLOXTotalCMS.host.versionPointer_s.substring(0, 1) == "75");

	//-- 4.71.67.2013.07.09 in Tucson, AZ asking for a CC version as well
	this.com.townnews.BLOXTotalCMS.host.isCC = (this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion.indexOf('CC') >= 0);

	//-- 4.72.43.2014.01.20 set a version flag for prior to 9.2 when
	//--	Adobe changed the UI preference for white UI
	//-- 5.17.04.2017.01.09 Noticed that the check below was textural and it 
	//--	should instead have been numerical
	//-- 5.20.34.2018.09.11 INDESIGN-850 again, this will use the string version
	this.com.townnews.BLOXTotalCMS.host.isCC_LessThanCC_2 = this.com.townnews.BLOXTotalCMS.host.isCC && ((this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "90") || (this.com.townnews.BLOXTotalCMS.host.versionPointer_s == "91"));

	//-- 5.17.04.2017.01.09 INDESIGN-1560 Need a new flag for CC2017 and newer 
	//--	to enabled Track Changes
	//-- 5.20.34.2018.09.11 INDESIGN-850 this has to use the numeric version
	this.com.townnews.BLOXTotalCMS.host.isCC_2017_orNewer_b = (this.com.townnews.BLOXTotalCMS.host.versionPointer_n >= 120);

	//-- 5.20.03.2017.06.21 INDESIGN-850 Adobe InDesign CC2015 broke the
	//--	iconButton titles. They can me mimicked with just plane static
	//--	text, but we need a flag to know when that has happened.
	//-- 5.20.34.2018.09.11 INDESIGN-850 another for the numeric version
	this.com.townnews.BLOXTotalCMS.host.iconButtonTitlesUnsupported_b = (this.com.townnews.BLOXTotalCMS.host.versionPointer_n >= 110);

	//-- 5.26.02.2018.02.02 INDESIGN-2047 noticed that this can have a 
	//--	trailing space Also moving up so we don't have to call $.os
	//--	as often
	this.com.townnews.BLOXTotalCMS.host.st3 = ($.os).replace(/\s\s*$/, '');

	//-- 5.26.02.2018.02.02 INDESIGN-2047 switch $.os to .st3
	this.com.townnews.BLOXTotalCMS.host.fullName = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion + '/' + this.com.townnews.BLOXTotalCMS.host.av + ' running under ' + this.com.townnews.BLOXTotalCMS.host.st3;

	//-- 4.71.95e.2014.01.10 make an even shorter version
	//-- 5.26.02.2018.02.02 INDESIGN-2047 switch $.os to .st3
	this.com.townnews.BLOXTotalCMS.host.shortName = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion + '/' + this.com.townnews.BLOXTotalCMS.host.av + ' on ' + this.com.townnews.BLOXTotalCMS.host.st3;

	//-- 5.21.04.2017.10.03 INDESIGN-1912 add some more options
	this.com.townnews.BLOXTotalCMS.host.st2 = app.name + ' ' + this.com.townnews.BLOXTotalCMS.host.appCreativeSuiteVersion + '/' + this.com.townnews.BLOXTotalCMS.host.av;

	this.com.townnews.BLOXTotalCMS.host.isInDesign = new RegExp('InDesign', 'i').test(app.name);
	this.com.townnews.BLOXTotalCMS.host.isInCopy = new RegExp('InCopy', 'i').test(app.name);
	this.com.townnews.BLOXTotalCMS.host.isWindows = new RegExp('Windows', 'i').test($.os);
	//-- 5.10.04.2015.01.26 JIRA INDESIGN-155 specifically let us know if this is windows 7
	this.com.townnews.BLOXTotalCMS.host.isWindows7 = new RegExp('Windows 7', 'i').test($.os);
	this.com.townnews.BLOXTotalCMS.host.isWindowsXP = new RegExp('Windows XP', 'i').test($.os);

	//-- 5.15.24.2016.09.02 INDESIGN-1071 Add three new options, 1st for CURL
	this.com.townnews.BLOXTotalCMS.host.isWindows8 = new RegExp('Windows 8', 'i').test($.os);
	this.com.townnews.BLOXTotalCMS.host.isWindows10 = new RegExp('Windows 10', 'i').test($.os);

	//-- 5.15.26.2016.09.22 INDESIGN-1250 if this is any Windows install and
	//--	the path to the application includes (x86) then assume this is a
	//--	32bit install for CURL library
	this.com.townnews.BLOXTotalCMS.host.isWindows32Bit = false;
	this.com.townnews.BLOXTotalCMS.host.isWindows64Bit = false;
	if (this.com.townnews.BLOXTotalCMS.host.isWindows) {
		debugger;//5.37.09.2019.06.24 check 'filePath_fsName'
		if (this.com.townnews.BLOXTotalCMS.host.isCS5 || (unescape(app.filePath.fsName).indexOf('(x86)') > -1)) {
			this.com.townnews.BLOXTotalCMS.host.isWindows32Bit = true;
		}
		else if ($.os.indexOf("64") > 0) {
			this.com.townnews.BLOXTotalCMS.host.isWindows64Bit = true;
		}
	}
	//-- 4.40.8, change host tag to .isMacOS from .isMacintosh
	this.com.townnews.BLOXTotalCMS.host.isMacOS = (new RegExp('Macintosh', 'i').test($.os)) || (new RegExp('Mac\\s*OS', 'i').test($.os));

	//-- Version 3.70, add machine login information
	//-- 4.71.38.2013.05.14, adding protection on all of theses ;
	try {
		this.com.townnews.BLOXTotalCMS.host.machineLoginName = Folder.myDocuments.parent.displayName;
	}
	catch (err) {
		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineLoginName = 'error_produced_default_machineLoginName';
	}
	try {
		this.com.townnews.BLOXTotalCMS.host.machineName = $.getenv('COMPUTERNAME');
	}
	catch (err) {
		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineName = 'error_produced_default_machineName';
	}
	try {
		this.com.townnews.BLOXTotalCMS.host.machineDomainName = $.getenv('USERDOMAIN');
	}
	catch (err) {
		this.com.townnews.BLOXTotalCMS.localError = err;
		this.com.townnews.BLOXTotalCMS.host.machineDomainName = 'error_produced_default_machineDomainName';
	}
	//-- 4.71.52.2013.06.06, adding another host property because it
	//--	will show up in the revision files
	this.com.townnews.BLOXTotalCMS.host.scriptVersion = this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_');

	//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build numbers
	this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber = this.com.townnews.BLOXTotalCMS.scriptBuildNumber;
	this.com.townnews.BLOXTotalCMS.host.scriptVersionNumberWithBuild = this.com.townnews.BLOXTotalCMS.host.scriptVersion + '-' + this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber;

	//-- 4.71.93c.2013.11.14 adding a host for revision files that is shorter
	//-- 4.71.95e.2014.01.10 shorten this more.
	//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build value
	this.com.townnews.BLOXTotalCMS.hostForRevisionFiles = { app: this.com.townnews.BLOXTotalCMS.host.shortName, v: this.com.townnews.BLOXTotalCMS.host.scriptVersion, b: this.com.townnews.BLOXTotalCMS.host.scriptBuildNumber };

	//-- 4.21 add a launch variable to keep the global namespace cleaner.
	this.com.townnews.BLOXTotalCMS.launch = new Object();

	//-- 4.31.0 add a paremeter for login inforation
	this.com.townnews.BLOXTotalCMS.login = new Object();
	//-- Below is a flag for revised versus original login code.
	this.com.townnews.BLOXTotalCMS.login.method = true;

	//------------------------------------------
	//-- R E S O U R C E   M A N A G E M E N T
	//------------------------------------------
	;
	//-- 4.21 Find this file
	this.com.townnews.BLOXTotalCMS.resources = new Object();
	this.com.townnews.BLOXTotalCMS.resources.rootScriptPath = locateRootScriptPath();

	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 if that includes the 
	//--	"tcms_indesign_client" share, then switch to the "tcms_data" share.
	//--	Different options exists when developing code
	this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent;
	this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.toString();
	this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = false;
	this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'tcms_indesign_client';
	// if ($.level > 0) {
	// 	if (this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC && this.com.townnews.BLOXTotalCMS.host.isMacOS) {

	// 		//-- edit this to convince it to match
	// 		this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'tcms-indesign-client'
	// 	}
	// 	else {
	// 		this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare = 'test_client';
	// 	}
	// }
	this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s.indexOf(this.com.townnews.BLOXTotalCMS.launch.remoteLaunchShare)

	if (this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i > -1) {
		debugger;
		this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = Folder(this.com.townnews.BLOXTotalCMS.resources.rootScriptPath_original_s.substr(0, this.com.townnews.BLOXTotalCMS.launch.positionOfRemoteLaunchShare_i) + 'tcms_data');
		if (!this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.exists) {

			die('Can NOT reach the expected root script path when loading from an appliance release.\n\nExpected path is:\n   ' + unescape(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.fsName));
			$.bp(true);
		}
		this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = true;
	}
	// else if (($.level > 0) && this.com.townnews.BLOXTotalCMS.host.isInDesign && this.com.townnews.BLOXTotalCMS.host.isCC && this.com.townnews.BLOXTotalCMS.host.isMacOS) {

	// 	//manually redirect here
	// 	this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d = Folder('~/tcms/tcms_data');
	// 	if (!this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.exists) {

	// 		die('Can NOT reach the expected root script path when loading from an appliance release.\n\nExpected path is:\n   ' + unescape(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.fsName));
	;
	// 	}
	// 	this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b = true;
	// }

	//------------------------
	//-- U S E R   A G E N T
	//------------------------
	//-- 5.26.02.2018.02.02 INDESIGN-2047 creating the User-Agent code based
	//--	on this formula: 
	//--	host app/host app version (os and version) c/clientversion source
	//--	where 'source' is A for tcms_indesign_client based else L for some
	//--	sort of localized install. 
	this.com.townnews.BLOXTotalCMS.host.user_agent = (this.com.townnews.BLOXTotalCMS.host.isInDesign ? 'ID/' : 'IC/') + this.com.townnews.BLOXTotalCMS.host.av + ' (' + (this.com.townnews.BLOXTotalCMS.host.st3).replace('Windows', 'W').replace('Macintosh', 'M').replace('Service Pack', 'sp') + ') c/' + this.com.townnews.BLOXTotalCMS.host.scriptVersionNumberWithBuild + (this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b ? ' A' : ' L');


	//------------------------------------------------
	//-- V E R S I O N   A N D   H O S T   F I L E S
	//------------------------------------------------
	//-- 4.42.01, Add support for writing out the version
	//-- 4.66.05, 2012.06.08, make the file a .version so that the 
	//--	CVS knows what it is.
	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
	//~ 	this.com.townnews.BLOXTotalCMS.resources.versionFileRef = File (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace (new RegExp ('\\.','g'), '_') + '.version') ;
	this.com.townnews.BLOXTotalCMS.resources.versionFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_') + '.version');
	if (!this.com.townnews.BLOXTotalCMS.resources.versionFileRef.exists) {
		try {
			this.com.townnews.BLOXTotalCMS.resources.versionFileRef.open('w');
			this.com.townnews.BLOXTotalCMS.resources.versionFileRef.close();
		}
		catch (err) {
			this.com.townnews.BLOXTotalCMS.localError = err;
		}
	}
	//-- 4.71.52.2013.06.06, add support for writing out .host files so
	//--	that the logs can know if they need to sort the files. Basically
	//--	if there is two .application files, sorting will happen. 
	//-- 4.71.52.2013.06.06, write this application.
	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
	this.com.townnews.BLOXTotalCMS.resources.hostFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/' + app.name.replace(new RegExp('( \\.)', 'g'), '_') + '.host');
	if (!this.com.townnews.BLOXTotalCMS.resources.hostFileRef.exists) {
		try {
			this.com.townnews.BLOXTotalCMS.resources.hostFileRef.open('w');
			this.com.townnews.BLOXTotalCMS.resources.hostFileRef.close();
		}
		catch (err) {
			this.com.townnews.BLOXTotalCMS.localError = err;
		}
	}
	//

	//-- 4.71.52.2013.06.06, count the number of host applications
	//-- 4.71.52.2013.06.06, set the flag if more than 1
	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
	this.com.townnews.BLOXTotalCMS.resources.multipleHosts = (this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d.getFilesWithSuffix('.host').length > 1);
	;
	//-- Add an object for the loaded files.
	this.com.townnews.BLOXTotalCMS.resources.loaded = new Object();

	//-- then the resources 
	//-- 4.31.1 rename to lower case
	this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootScriptPath + '/resources');


	//---------------------------------------------------------------------
	//-- E N A B L E D   &   D I S A B L E D
	//---------------------------------------------------------------------
	//-- 4.71.05.2013.03.11 look for all enabled and disabled files 
	//--	and store those files
	//-- Create an array of file extensions. 
	this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions = [ 'disabled', 'enabled' ];
	//-- loop through each file extension
	for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {
		//-- Ad the file extension object if it doesn't exist
		if (!this.com.townnews.BLOXTotalCMS.resources.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ])) {
			this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ] = new Object();
		}
		//-- Get all the files with that extension and store them in 
		//--	a variable using the extension name.
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 			this.com.townnews.BLOXTotalCMS.launch [ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[this.com.townnews.BLOXTotalCMS.launch.fi] + 'Files' ] = Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent).getFilesWithSuffix ('.' + this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[this.com.townnews.BLOXTotalCMS.launch.fi]) ;
		this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ] = Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d).getFilesWithSuffix('.' + this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
		//-- loop through each found file so make an associative array 
		//--	with each main file name
		for (this.com.townnews.BLOXTotalCMS.launch.si = 0; this.com.townnews.BLOXTotalCMS.launch.si < this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ].length; this.com.townnews.BLOXTotalCMS.launch.si++) {
			if (!this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ].hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].nameWithoutExtension())) {
				this.com.townnews.BLOXTotalCMS.resources[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] ][ this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].nameWithoutExtension() ] = true;

				//-- 4.71.07.2013.03.12 also log them in the loaded files
				this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ].name ] = this.com.townnews.BLOXTotalCMS.launch[ this.com.townnews.BLOXTotalCMS.launch.specialFilesExtensions[ this.com.townnews.BLOXTotalCMS.launch.fi ] + 'Files' ][ this.com.townnews.BLOXTotalCMS.launch.si ];
			}
		}
	}
	//------------------------------------------------
	//-- L O C A L   R E S O U R C E S   F O L D E R
	//------------------------------------------------
	//-- 5.29.01.2018.03.17 INDESIGN-2110 If the host is MacOS and if a special
	//--	enabled file exists then allow the local resources folder to be 
	//--	placed in the user's home folder rather than the User Data folder 
	//--	as it normally is. 
	;
	if (this.com.townnews.BLOXTotalCMS.host.isMacOS && this.com.townnews.BLOXTotalCMS.resources.enabled.hasOwnProperty('MacOS_homeFolder')) {
		this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local = new Folder('~/BLOX Total CMS/resources');

	}
	else {
		//-- This is the normal location for all users except those above
		//-- 4.57.02, 2012.01.30, construct local copies
		this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local = new Folder(Folder.userData + '/BLOX Total CMS/resources');
	}
	if (!this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local.verify()) {
		die('The local \'resources\' folder does not exists at: \'' + unescape(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local) + '\' and launch cannot continue.');
	}
	//
	//---------------------------------------------
	//-- H A R D   C O D E D   R E S O U R C E S
	//---------------------------------------------

	//-- Load all the hard coded resources
	//-- The flash file the handles the JSON encoding
	//-- 4.31.1 rename to lower case
	//-- 4.57.02, 2012.01.30, copy then load
	this.com.townnews.BLOXTotalCMS.resources.JSONflashFile = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/tcms.swf');
	if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/tcms.swf').copy(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile)) {
		//-- 4.66.12, 2012.06.21 typo fix
		die('Unable to create a local copy of the \'tcms.swf\' file. The BLOX Total CMS launch sequence cannot continue.');
	}
	//-- 4.33, skip this if stand alone AdMarket Install
	//-- 4.65.25, 2012.05.30 also handle standalone ad owl
	//-- 5.15.24.2016.09.07 INDESIGN-1230 remove Ad Market and Ad Owl
	//-- 5.14.67.2016.10.04 INDESIGN-1263, load the logo file again. 
	this.com.townnews.BLOXTotalCMS.resources.logoImage = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/blox-total-cms-logo.png');
	if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/blox-total-cms-logo.png').copy(this.com.townnews.BLOXTotalCMS.resources.logoImage)) {
		//-- 4.66.12, 2012.06.21 typo fix
		die('Unable to create a local copy of the \'blox-total-cms-logo.png\' file. The BLOX Total CMS launch sequence cannot continue.');
	}
	//-- 5.13.03.2016.02.01 INDESIGN-923 check to see if the preset for PDF 
	//--	previews for Page Tracker exists
	this.com.townnews.BLOXTotalCMS.resources.PageTrackerPreview = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/PageTrackerPreview.joboptions');
	if (!File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/PageTrackerPreview.joboptions').copy(this.com.townnews.BLOXTotalCMS.resources.PageTrackerPreview)) {
		die('Unable to create a local copy of the \'PageTrackerPreview.joboptions\' file. The BLOX Total CMS launch sequence cannot continue.');
	}
	//-- 4.39.2, move all icons to an icons directory
	//-- 4.57.02, make that a local directory
	this.com.townnews.BLOXTotalCMS.resources.iconsFolder = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/icons/');
	if (!this.com.townnews.BLOXTotalCMS.resources.iconsFolder.exists) {
		die('The \'icons\' folder does not exists at: \'' + unescape(this.com.townnews.BLOXTotalCMS.resources.iconsFolder) + '\' and launch cannot continue.');
	}
	else {
		//-- Load the icons. Revised setup on 2012.01.30
		//--	for version 4.57.02 to work from local copies.
		this.com.townnews.BLOXTotalCMS.resources.icons = new Object();

		//-- 4.40.8 change to the way 'getFiles' is used
		this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server = this.com.townnews.BLOXTotalCMS.resources.iconsFolder.getFilesWithSuffix('.png');
		//-- loop through the found files
		for (this.com.townnews.BLOXTotalCMS.launch.iconI = this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server.length - 1; this.com.townnews.BLOXTotalCMS.launch.iconI >= 0; this.com.townnews.BLOXTotalCMS.launch.iconI--) {
			//-- create a temporary variable to speed things along
			this.com.townnews.BLOXTotalCMS.launch.iconName = this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server[ this.com.townnews.BLOXTotalCMS.launch.iconI ].nameWithoutExtension()

			this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ] = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.launch.iconName + '.png');
			if (!this.com.townnews.BLOXTotalCMS.resources.allIconFiles_Server[ this.com.townnews.BLOXTotalCMS.launch.iconI ].copy(this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ])) {
				die('Unable to successfully copy the \'' + this.com.townnews.BLOXTotalCMS.launch.iconName + '\' to: \'' + unescape(this.com.townnews.BLOXTotalCMS.resources.icons[ this.com.townnews.BLOXTotalCMS.launch.iconName ].fsName));
			}
		}
		//-- These two legacy icons are special. Revised setup on 2012.01.30
		//--	for version 4.57.02 to work from local copies.
		this.com.townnews.BLOXTotalCMS.resources.falseImage = this.com.townnews.BLOXTotalCMS.resources.icons[ 'false' ];
		this.com.townnews.BLOXTotalCMS.resources.trueImage = this.com.townnews.BLOXTotalCMS.resources.icons[ 'true' ];
	}
	//-- Verify that the Resources folder exists
	if (!this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server.exists) {
		//-- Yes, it is somewhat out of order to finally check for this now, 
		//--	but it will work fine.
		die('Resources folder not found');
	}
	else if (!this.com.townnews.BLOXTotalCMS.resources.JSONflashFile.exists) {
		die('Flash file for JSON encoding does not exist.\n\nExpected at:\n   ' + unescape(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile.fsName));
	}
	else {
		//-- Resources folder exists on Server
		//-- 5.12.57.2015.12.23 INDESIGN-866, check for a version file on the
		//--	server version. 
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 if the code is loaded from a 
		//--	PacMan install, then don't attempt to check for or create these
		//--	two files.
		if (this.com.townnews.BLOXTotalCMS.resources.runningFromPacManInstall_b === false) {
			this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.scriptVersion.replace(new RegExp('\\.', 'g'), '_') + '.version');
			if (!this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.exists) {
				try {
					this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.open('w');
					this.com.townnews.BLOXTotalCMS.resources.serverVersionFileRef.close();
				}
				catch (err) {
					this.com.townnews.BLOXTotalCMS.localError = err;
				}
			}
			//-- 5.16.06.2016.12.02 INDESIGN-1522 add a build file using the existing cleaned copy
			this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + '.build');
			if (!this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.exists) {
				try {
					this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.open('w');
					this.com.townnews.BLOXTotalCMS.resources.scriptVersionNumberWithBuildFileRef.close();
				}
				catch (err) {
					this.com.townnews.BLOXTotalCMS.localError = err;
				}
			}
		}
		//-- 5.12.57.2015.12.23 INDESIGN-868 add a client version in an
		//--	activeClientFolderName.txt file. Only do this if the folder 
		//--	name starts with blox total cms or ActiveVersion		
		this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName = this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.name;

		//-- 5.12.67.2016.01.13 INDESIGN-887 change the regular expression to
		//--	limit more characters.
		//~ 		this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean = this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName.toLowerCase ().replace (/(\W|\s|_|-)/gim, '') ; 
		this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean = this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName.toLowerCase().replace(/[^a-z]/gm, '');;

		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 		this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef = File (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/activeClientFolderName.txt') ;
		this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/activeClientFolderName.txt');
		if (this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('activeversion') == 0) {
			try {
				this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.remove();
			}
			catch (err) {
				this.com.townnews.BLOXTotalCMS.localError = err;
			}
		}
		else if ((this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('bloxtotalcms') > -1) || (this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName_clean.indexOf('developmentversion') == 0)) {
			if (!this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.exists) {
				//-- file doesn't exist. Create it
				try {
					this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.open('w');
					this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.write(this.com.townnews.BLOXTotalCMS.resources.rootScriptFolderName);
					this.com.townnews.BLOXTotalCMS.resources.activeClientFolderNameFileRef.close();
				}
				catch (err) {
					this.com.townnews.BLOXTotalCMS.localError = err;
				}
			}
		}
		//-- record the loaded files
		this.com.townnews.BLOXTotalCMS.resources.skipped = new Object();
		//-- 4.24 add a replaced
		this.com.townnews.BLOXTotalCMS.resources.replaced = new Object();

		//-- 4.24 don't load the jsx files if working in debug mode.
		if ($.level == 0) {
			//-- get all the .jsxbin files and load them.
			this.com.townnews.BLOXTotalCMS.resources.jsxbin = new Object();
			this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/jsxbin');
			if (this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder.exists) {
				//-- 4.22, set a static variable
				this.com.townnews.BLOXTotalCMS.resources.jsxbin.folderExists = true;
				//-- 4.40.8 change to the way 'getFiles' is used
				this.com.townnews.BLOXTotalCMS.resources.jsxbin.files = this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder.getFilesWithSuffix(".jsxbin");
				if (this.com.townnews.BLOXTotalCMS.resources.jsxbin.files != null) {
					this.com.townnews.BLOXTotalCMS.resources.jsxbin.numFiles = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.length;

					//-- 5.36.24.2019.04.26 INDESIGN-2540 sort the names
					this.com.townnews.BLOXTotalCMS.resources.jsxbin.files = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.sort();

					//loop and load
					for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.jsxbin.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {
						//-- Use doScript to read the file and execute it
						this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
						//-- Add the raw filename to the loaded files to prevent the
						//--	jsx version from loading later
						this.com.townnews.BLOXTotalCMS.resources.loaded[ File(this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension() ] = this.com.townnews.BLOXTotalCMS.resources.jsxbin.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];
					}
				}
			}
		}
		//-- get all the .jsx files and load them.
		this.com.townnews.BLOXTotalCMS.resources.jsx = new Object();
		this.com.townnews.BLOXTotalCMS.resources.jsx.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/jsx');
		if (this.com.townnews.BLOXTotalCMS.resources.jsx.folder.exists) {
			//-- 4.40.8 change to the way 'getFiles' is used

			this.com.townnews.BLOXTotalCMS.resources.jsx.files = this.com.townnews.BLOXTotalCMS.resources.jsx.folder.getFilesWithSuffix(".jsx");
			if (this.com.townnews.BLOXTotalCMS.resources.jsx.files != null) {
				this.com.townnews.BLOXTotalCMS.resources.jsx.numFiles = this.com.townnews.BLOXTotalCMS.resources.jsx.files.length;
				$.bp(this.com.townnews.BLOXTotalCMS.resources.jsx.numFiles == 0)
				//-- 5.36.24.2019.04.26 INDESIGN-2540 sort the names
				this.com.townnews.BLOXTotalCMS.resources.jsx.files = this.com.townnews.BLOXTotalCMS.resources.jsx.files.sort();

				//loop and load
				for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.jsx.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {
					//-- 5.37.06.2019.06.11 INDESIGN-1951 wrap this in 
					//--	try / catch to aid in development debugging 
					//--	Need a way to see 
					//--	the variable that has the script name. 
					try {
						//-- skipping jsx versions if the jsxbin exists. 
						this.com.townnews.BLOXTotalCMS.launch.jsxName = File(this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension();

						//-- 4.22, if the file isn't loaded or if the 
						//--	modification date of the .jsx is newer than the 
						//--	modification date of the jsxbin, then load it. 
						//-- 5.35.03.2018.12.17 no ticket. Change dev only launch
						//--	so that the JSX can be up to 1 second older to 
						//--	deal with the way GIT updates things when 
						//--	switching versions
						if ((!this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) || (this.com.townnews.BLOXTotalCMS.resources.jsxbin.folderExists && (this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ].modified - File(this.com.townnews.BLOXTotalCMS.resources.jsxbin.folder + '/' + this.com.townnews.BLOXTotalCMS.launch.jsxName + '.jsxbin').modified > 1001))) {

							//-- Use doScript to read the file and execute it
							this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
							//-- 4.24 add the replaced listing
							if (this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) {
								//-- already loaded as a JSXBIN
								this.com.townnews.BLOXTotalCMS.resources.replaced[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ];
							}
							//-- Add the raw filename to the loaded files for
							//--	later logging.
							this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.jsx.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];
						}
					}
					catch (err) {
						//-- 5.37.06.2019.06.11 debugging 
						localError = err;
						localError.javascriptFileName_s = this.com.townnews.BLOXTotalCMS.launch.jsxName;
						$.bp(true);
						throw err;
					}
				}
			}
		}
		//-- Check that items were loaded
		if (this.com.townnews.BLOXTotalCMS.resources.loaded.toSource() == '({})') {
			die('No ExtendScript files loaded. Can NOT continue.');
			app.quit();
		}
		else {
			//-- Continue with the startup procedure ;

			//  define the JSON class object
			//-- Ideally this wouldn't be a globally exposed item. 
			if (typeof (JSON) == "undefined") {
				//-- 4.71.67.2013.07.10 in Tucson, AZ, skip the SWF if this is CC
				if (this.com.townnews.BLOXTotalCMS.host.isCC) {
					JSON = new CreativeCloud_jsonClass();
				}
				else {
					//-- pre CC method
					JSON = new jsonClass(this.com.townnews.BLOXTotalCMS.resources.JSONflashFile);
				}
			}
		}
		//--------------------------------------------------------------------
		//-- S E R V E R S. J S X
		//--------------------------------------------------------------------
		//-- 5.36.24.2019.04.26 INDESIGN-2540, remove the check for ad Owl and asd Market
		//-- 4.25.11 load the servers file. Take the first one that is found
		this.com.townnews.BLOXTotalCMS.launch.userServers = File(Folder.userData + '/BLOX Total CMS/servers.jsx');

		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		this.com.townnews.BLOXTotalCMS.launch.serverServers = File(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/servers.jsx');
		if (this.com.townnews.BLOXTotalCMS.launch.userServers.exists) {
			//-- 5.36.24.2019.04.26 INDESIGN-2540 protect this so that if the 
			//--	servers file has language issues, login can proceed.
			try {
				this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.launch.userServers);
				this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.userServers.name ] = this.com.townnews.BLOXTotalCMS.launch.userServers;
				this.com.townnews.BLOXTotalCMS.resources.servers = servers();
			}
			catch (err) {
				//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
				this.com.townnews.BLOXTotalCMS.localError = err;
				$.bp(true);
			}
		}
		else if (this.com.townnews.BLOXTotalCMS.launch.serverServers.exists) {
			//-- 5.36.24.2019.04.26 INDESIGN-2540 protect this so that if the 
			//--	servers file has language issues, login can proceed.
			try {
				this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.launch.serverServers, ScriptLanguage.javascript);
				this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.serverServers.name ] = this.com.townnews.BLOXTotalCMS.launch.serverServers;
				this.com.townnews.BLOXTotalCMS.resources.servers = servers();
			}
			catch (err) {
				//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
				this.com.townnews.BLOXTotalCMS.localError = err;
				$.bp(true);
			}
		}
		else {
			this.com.townnews.BLOXTotalCMS.resources.servers = undefined;
			//-- it will be set later
		}

		//--------------------------------------------------------------------
		//-- O V E R I D E S   S P E C I F I C   F I L E S
		//--------------------------------------------------------------------
		//-- 4.33, skip this if it is a standalone adMarket Install
		//-- 4.65.25, and the same if it is ad owl stand alone
		if ((!this.com.townnews.BLOXTotalCMS.AdMarketStandAlone) && (!this.com.townnews.BLOXTotalCMS.AdOwlStandAlone)) {
			locateOverrides();
			//-- Now load those override files
			if (this.com.townnews.BLOXTotalCMS.resources.overrides.files != null) {
				this.com.townnews.BLOXTotalCMS.resources.overrides.numFiles = this.com.townnews.BLOXTotalCMS.resources.overrides.files.length;
				//-- loop through those files
				for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.overrides.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {

					//-- skip file jsx versions if the file has already been 
					//--	loaded 
					this.com.townnews.BLOXTotalCMS.launch.jsxName = File(this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension();

					if (!this.com.townnews.BLOXTotalCMS.resources.loaded.hasOwnProperty(this.com.townnews.BLOXTotalCMS.launch.jsxName)) {

						//-- Use doScript to read the file and execute it
						this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
						//-- Add the raw filename to the loaded files to 
						//--	for later logging. 
						this.com.townnews.BLOXTotalCMS.resources.loaded[ this.com.townnews.BLOXTotalCMS.launch.jsxName ] = this.com.townnews.BLOXTotalCMS.resources.overrides.files[ this.com.townnews.BLOXTotalCMS.launch.fi ];
					}
				}
			}
		}
		//--------------------------------------------------------------------
		//-- C E N T E R   S P E C I F I C   S C R I P T S -- A D D - O N S
		//--------------------------------------------------------------------
		//-- 4.31.2 Load the centerSpecific Scripts. 
		this.com.townnews.BLOXTotalCMS.resources.centerSpecific = new Object();

		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 		this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/Add-ons') ;
		//-- 5.32.26
		this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/Add-ons');

		if (this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.exists) {
			//-- 4.40.8 change to the way 'getFiles' is used		
			this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.getFilesWithSuffix('.jsx*')
			if (this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files != null) {
				this.com.townnews.BLOXTotalCMS.resources.centerSpecific.numFiles = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files.length;
				//loop and load
				for (this.com.townnews.BLOXTotalCMS.launch.fi = 0; this.com.townnews.BLOXTotalCMS.launch.fi < this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files.length; this.com.townnews.BLOXTotalCMS.launch.fi++) {
					//-- Use doScript to read the Add-Ons file and execute it
					this.com.townnews.BLOXTotalCMS.launch.loadResult = app.doScript(this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]);
					//-- Add the raw filename to the loaded files 
					this.com.townnews.BLOXTotalCMS.resources.loaded[ File(this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]).nameWithoutExtension() ] = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.files[ this.com.townnews.BLOXTotalCMS.launch.fi ]
				}
			}
		}
		else {
			//-- INDESIGN-2229
			this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder.verify();
		}
		//---------------------------------------------------------------------
		//-- Version Folders Parent
		//---------------------------------------------------------------------
		//-- used in pathConfiguration to locate the several different folders
		this.com.townnews.BLOXTotalCMS.resources.versionFoldersParent_d = this.com.townnews.BLOXTotalCMS.resources.centerSpecific.folder;




		//----------------------------
		//-- C U R L   L I B R A R Y
		//----------------------------
		//-- 5.15.39.2016.11.04 INDESIGN-1301 Copy CURL library to local resources
		this.com.townnews.BLOXTotalCMS.resources.CURL = new Object();

		this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = versionIsNewerThanOrEqualToTarget(this.com.townnews.BLOXTotalCMS.scriptVersion, '5.15.39', 3);
		if (this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b) {
			if (this.com.townnews.BLOXTotalCMS.host.isWindows64Bit) {
				this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib64.dll";
			}
			else if (this.com.townnews.BLOXTotalCMS.host.isWindows32Bit || this.com.townnews.BLOXTotalCMS.host.isWindows) {
				this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib.dll";
			}
			else if (this.com.townnews.BLOXTotalCMS.host.isMacOS) {
				this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s = "HttpLib.framework.zip";
				this.com.townnews.BLOXTotalCMS.resources.CURL.library_Framework_s = "HttpLib.framework";
			}
			else {
				this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
			}
		}
		if (this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b) {
			this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

			this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);


			//--------------------------
			//-- W I N D O W S   D L L
			//--------------------------
			if (this.com.townnews.BLOXTotalCMS.host.isWindows) {
				if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.exists) {
					this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
				}
				else {
					if (!this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.exists) {
						if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f)) {
							$.bp(true);
							this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
						}
					}
					else {
						//-- 5.15.39.2016.11.07 INDESIGN-1301 if the length is
						//--	different, or the modification date is 
						//--	different, assume it is a different version
						//--	and recopy it locally. 
						if ((this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.modified > this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.modified) || (this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.length != this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f.length)) {
							if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f)) {
								$.bp(true);
								this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
							}
						}
					}
				}
			}
			else if (this.com.townnews.BLOXTotalCMS.host.isMacOS) {
				//----------------------------------
				//-- M a c O S   F R A M E W O R K
				//----------------------------------
				//-- Do not replicate nor decompress if in debug mode
				if ($.level > 0) {

					//------------------------------------
					//-- M a c O S   D E B U G   M O D E
					//------------------------------------
					//
					//-- When testing in debug mode, just use the "Server's" 
					//--	version of the .framework "folder". Do not 
					//--	un-compress and use a local freshly uncompressed 
					//--	version as then the .framework itself cannot be 
					//--	debugged. 
					this.com.townnews.BLOXTotalCMS.resources.CURL.localFile_f = this.com.townnews.BLOXTotalCMS.resources.CURL.serverFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

				}
				else {
					//----------------------------
					//-- N O R M A L   M a c O S
					//----------------------------
					this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Server + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

					this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f = File(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_FileName_s);

					this.com.townnews.BLOXTotalCMS.resources.CURL.localFrameworkFolder_d = Folder(this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local + '/' + this.com.townnews.BLOXTotalCMS.resources.CURL.library_Framework_s);

					if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.exists) {
						this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
					}
					else {
						if (!this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f.exists) {
							$.bp(true);
							if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f)) {
								this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
							}
							else if (!MacOS_UN_zip(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f, this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local, true)) {

								//------------------------------------------
								//-- M a c O S   N O   D E C O M P R E S S
								//------------------------------------------
								//-- 5.33.09.2018.10.10 INDESIGN-2363 no
								//--	decompress if disabled file exists
								//--	see else if above

								// decompress it								
								//-- 5.16.02.2016.11.17 The decompression should 
								//--	happen in the resources folder, NOT the 
								//--	another layer of framework folders
								this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
							}
						}
						else {
							//-- 5.15.39.2016.11.07 INDESIGN-1301 if the length is
							//--	different, or the modification date is 
							//--	different, assume it is a different version
							//--	and recopy it locally. 
							//-- 5.16.03.2016.11.18 INDESIGN-1503 set this 
							//--	procedure to happen always until reaching
							//--	client 5.18. This to aid in the installation
							//--	of this process. 
							if ((!versionIsNewerThanOrEqualToTarget(this.com.townnews.BLOXTotalCMS.scriptVersion, '5.18', 2)) || (this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.modified > this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f.modified)) {
								if (!this.com.townnews.BLOXTotalCMS.resources.CURL.serverZipFile_f.copy(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f)) {
									$.bp(true);
									this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
								}
								else if (!this.com.townnews.BLOXTotalCMS.resources.disabled.hasOwnProperty('updateFramework')) {
									//------------------------------------------
									//-- M a c O S   N O   D E C O M P R E S S
									//------------------------------------------
									//-- 5.33.09.2018.10.10 INDESIGN-2363 no
									//--	decompress if disabled file exists
									//--	see else if above

									// decompress it
									//-- 5.16.02.2016.11.17 The decompression should 
									//--	happen in the resources folder, NOT the 
									//--	another layer of framework folders
									if (!MacOS_UN_zip(this.com.townnews.BLOXTotalCMS.resources.CURL.localZipFile_f, this.com.townnews.BLOXTotalCMS.resources.resourcesFolder_Local, true)) {
										this.com.townnews.BLOXTotalCMS.resources.CURL.isOption_b = false;
									}
								}
							}
						}
					}
				}
			}
		}
		//-- Everything is supposed to be loaded by now except for the 
		//--	site specific configuration files which are to be loaded 
		//--	as needed by their functions. 		

		//-- set the default server if it wasn't loaded earlier
		if (this.com.townnews.BLOXTotalCMS.resources.servers == undefined) {
			this.com.townnews.BLOXTotalCMS.launch.defaultServer = getDefaultServer();
			this.com.townnews.BLOXTotalCMS.resources.servers = [ { name: this.com.townnews.BLOXTotalCMS.launch.defaultServer, address: this.com.townnews.BLOXTotalCMS.launch.defaultServer } ];
		}
		//-- 4.31.14, locate the general documents as part of the 
		//--	resources and then list the filenames as well
		locateGeneralDocuments();
		//---------------------------------------------------------------------
		//-- Enable Logs and other items.
		//-- 4.68.04, 2012.08.28, check for a valid login setup
		if (onLaunch4()) {
			launchLogLaunchDetails();
			//-- login should happen here
			//-- 4.21 Radically new setup for loading the event handlers
			//-- 4.31.2 again change the function call for handling the login.
			//-- 4.33 if an AdMarket install then the setup is different
			//-- 4.65.25, 2012.05.30, also different for Ad Owl stand alone
			//-- 5.37.10.2019.07.02 no ticket, remove adOwl and AdMarket 
			//--	and then pass temporary items
			//-- 5.41.03.2019.10.24 INDESIGN-2647 pass true for lazyLaunch_b
			this.com.townnews.BLOXTotalCMS.launch.setupResult = loginAndSetupMenusAndEvents(false, this.debug_o, true);
			//-- 5.12.20.2015.07.27 INDESIGN-622 more control for when login fails. 
			if (this.com.townnews.BLOXTotalCMS.launch.setupResult == true) {
				//-- 4.31.11 move to separate function
				launchDisplayFinalMessages();
			}
		}
		//-- 4.03 try to delete global name space variable
		delete this.com.townnews.BLOXTotalCMS.launch;
		//-- 5.37.10.2019.07.02 no ticket, delete this temporary item. 
		delete this.debug_o;
	}
}
catch (err) {
	//-- 5.36.25.2019.05.06 INDESIGN-2547 provide a way to watch
	this.com.townnews.BLOXTotalCMS.localError = err;
	var localError = err;
	handleError(err, undefined, undefined, true, false, 'BLOX Total CMS Plug-in Launch Error')
}
//-----------------------------------------------------------------------------
//
function locateRootScriptPath () {
	var err;
	var localError;
	var root_d = null;
	var script_f = null;
	//-- Standard method of locating a script file. If run from the host
	//--	application, it gets correct path. If run from ESTK, it errors
	//--	but knows the path to the script file causing the error. That
	//--	error gets parsed and, due to the constructs of BLOX Total CMS
	//--	we return the path two folders up. 
	try {
		script_f = app.activeScript;
	}
	catch (err) {
		localError = err;
		script_f = new File(err.fileName);
		if (!script_f.exists) {
			return Folder.selectDialog("Select the 'ActiveVersion' folder containing the 'Startup Scripts' and 'resources' folders.")
		}
	}
	root_d = script_f.parent.parent; //-- TWO (2) up. Two thumbs up? 
	if (root_d.exists) {
		return Folder(root_d.fsName);
	}
	return Folder.selectDialog("Select the 'ActiveVersion' folder containing the 'Startup Scripts' and 'resources' folders.")
}
//
//
function die (message) {
	alert('ERROR: The BLOX Total CMS Plug-In is not correctly installed.\n\nFunctionality disabled.' + ((message != undefined) ? '\nDetails: ' + message : ''), 'BLOX Total CMS', true)
	//-- no way to truly exit in CS5 and we don't want to force a quit
	//--	thus, the else

	//-- 5.36.25.2019.05.06 INDESIGN-2547 with new development function, just try to quit.
	if ($.level > 0) {
		app.quit();
	}

	//-- KILL ANY PREVIOUS MENU ITEMS 
	return null;
}
//
//
function handleError (err, pre, post, showSource, allowContinue, title, silent, reg) {
	//-------------------------------------------------------------------------
	//-- H A N D L E   E R R O R
	//-------------------------------------------------------------------------
	//-- Generic: No. It references hard coded log object. 
	//-------------------------------------------------------------------------
	//-- Purpose: This is a generic error handler that can show an error with 
	//--		extra information about the line of code that generated the 
	//--		error. 
	//-------------------------------------------------------------------------
	//-- Parameters: 5
	//--		err: The error object that was caught
	//--		pre: a string that you want to include at the beginning.
	//--		post: a string that you want to include at the end.
	//--		showSource: a boolean. Set to True to display the lines near 
	//--			the error.
	//--		allowContinue: a Boolean. When set to true confirm will be
	//--			displayed. And the result of the confirm is returned. When
	//--			set to false, then false will be returned.
	//-------------------------------------------------------------------------
	//-- Returns: the result of the confirm dialog.
	//-------------------------------------------------------------------------


	//-- 5.36.06.2019.02.12 INDESIGN-2143 modernize declarations and add OS 
	//--	version if known
	var allLines_a = null;
	var err;
	var errLine_i = 0;
	var li_i = 0;
	var ll;
	var localError;
	var logBreak = "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n";
	var logPrefix = "\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n";
	var lineAfter_i = 0;
	var lineBefore_i = 0;
	var msg = '';
	var msg_a = new Array();
	var numLinesAfter_i = 2;
	var numLinesBefore_i = 8;
	var r = null;
	var stack_s = null;
	var versionLine_s = '';
	//

	//-- Edited 2009.11.20 to add breaks in the prior lines of code. 
	//-- Edited 2010.01.21 to add more breaks to make it more readable. 
	//-- Edited 2010.09.20 to allow the continue to be optional. 
	if (allowContinue == undefined) {
		allowContinue = true; // default to old behavior
	}
	//-- Use the prefix if it exists 
	if (pre) {
		msg = pre + '\n';
	}
	else {
		msg = '';
	}
	//-- Build the first part of the error.
	//-- 2010.01.29 change to += for version 3.27
	msg += '\nError: ' + err.message + '\n\nType: ' + err.name
	msg += '\nNumber: ' + err.number

	//-- Add the source code if it is applicable.
	if (showSource) {
		//-- Edited 2009.02.09 to remove the encoding around the file name
		msg += '\n\nScript:\n   ' + unescape(err.fileName) + '\n\nLine: ' + err.line;

		msg += '\n\nSource Dump:'

		if (err.source) {
			//-- Add a heading above prior lines
			//-- Version 3.18 add more space before.
			msg += "\n\nLines Before:\n"

			//-- NOTE: 2010.09.28 the REG EXP on the whole source can be REAL SLOW

			//-- below modified for 2.55
			//-- Below modified for 3.00 to make it a little cleaner
			//--	Tab to space, two spaced to 1 space, starting space to no space.
			allLines_a = err.source.replace(new RegExp('\\t', 'gm'), ' ').replace(new RegExp('  ', 'gm'), ' ').replace(new RegExp('^ *', 'gm'), '').split("\n")

			//-- Determine the index of the first line of the code to display.			
			lineBefore_i = err.line - numLinesBefore_i;
			lineBefore_i = (lineBefore_i < 0) ? 0 : lineBefore_i;

			//-- Determine the index of the last line of the code to display
			lineAfter_i = err.line + numLinesAfter_i;
			lineAfter_i = (lineAfter_i > allLines_a.length) ? allLines_a.length : lineAfter_i;

			errLine_i = err.line - 1;
			for (li_i = lineBefore_i; (li_i < lineAfter_i) && (li_i < allLines_a.length); li_i++) {
				if (li_i == errLine_i) {
					//-- Add a header before the header and one for the next lines too
					//-- Version 3.18 Add more space
					msg += "\nError Line:\n" + "   " + allLines_a[ li_i ] + "\n\nNext Lines:\n";
				}
				else {
					//-- 2009.11.20 add an extra break to make reading the 
					//--	prior code easier. 
					msg += "   " + allLines_a[ li_i ] + '\n';
				} //-- End of else
			} //-- End of For loop		
		} //-- End of if (source exists)

		//-- Version 3.04 add stack to the error message
		try {
			stack_s = returnViewableStack(200, 0, 1);
			if (stack_s != '') {
				msg += '\n' + stack_s;
			}
		}
		catch (err) {
			localError = err;
		}
	} //-- End of if (showSource)
	//
	//-- Add the post text if it exists and return to caller
	msg = (post ? msg + '\n' + post : msg).replace('\t', ' ');
	//-- Version 2.24, make sure there is a message 
	if (msg == undefined) {
		msg = ''
	};
	//-- Version 2.24 make sure the setup has gotten far enough to create a log file
	if (this.hasOwnProperty('com') & this.com.hasOwnProperty('townnews') && this.com.townnews.hasOwnProperty('BLOXTotalCMS') && this.com.townnews.BLOXTotalCMS.hasOwnProperty('log')) {
		//-- 4.48.01, change to a proper log reference. Prior version was just 
		//--	a writeln in the log. This should dump to the error logs.
		ll = this.com.townnews.BLOXTotalCMS.log;

		//-- 4.69.29, 2012.10.20, in St. Louis
		//-- 5.36.06.2019.02.12 the test had been != undefined. 
		//--	I think it should be undefined
		if (reg == undefined) {
			reg = ll.reg(arguments.callee.name, [ 'handleError' ], true);
		}
		//-- 4.71.56.2013.06.11 Send along the error which will be used
		//--	to add to the log file on the server.
		//-- 5.21.01.2017.09.22 add the client version to the log
		//-- 5.36.06.2019.02.12 INDESIGN-2143 log the OS Version if known
		if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('host') && this.com.townnews.BLOXTotalCMS.host.hasOwnProperty('st6') && isNonEmptyString(this.com.townnews.BLOXTotalCMS.host.st6)) {

			//-- 5.36.22.2019.04.02 INDESIGN-2523 swap the order so that 
			//--	script version is always last
			ll.eLog(reg, logPrefix + msg + '\nOS Version: ' + this.com.townnews.BLOXTotalCMS.host.st6 + '\nClient Version: ' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + logBreak, err);
		}
		else {
			//-- legacy without OS Version
			ll.eLog(reg, logPrefix + msg + '\nClient Version: ' + this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + logBreak, err);
		}
	}
	//-- 4.03 allow a non-confirm dialog to be displayed
	//-- 4.40.4 allow the error to not be displayed to the user:
	if (silent) {
		//-- This next thing is a an attempt to limit crashes by 
		//--	keeping the redraw turned off.
		if ((!app.modalState) && app.scriptPreferences.enableRedraw) {
			msg = 'turning off redraw.';
			ll.iLog(reg, msg, true);
			app.scriptPreferences.enableRedraw = false;
		}
		return false;
	}
	//-- 4.70.15, adding a version tag to this area
	//-- 5.19.05.2017.03.21 Happy Spring INDESIGN-1678, include the 
	//--	build number here
	//-- 5.36.06.2019.02.12 INDESIGN-2143 log the OS Version if known
	if (this.com.townnews.BLOXTotalCMS.hasOwnProperty('host') && this.com.townnews.BLOXTotalCMS.host.hasOwnProperty('st6') && isNonEmptyString(this.com.townnews.BLOXTotalCMS.host.st6)) {
		versionLine_s = this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild + '/' + this.com.townnews.BLOXTotalCMS.host.st6;
	}
	else {
		//legacy without OS version
		versionLine_s = this.com.townnews.BLOXTotalCMS.scriptVersionNumberWithBuild;
	}
	if (allowContinue) {
		//-- Version 2p, Add a custom dialog
		//-- 5.38.03.2019.07.21 switch to a wider dialog using confirm$
		//-- 5.38.06.2019.07.31 can't use confirm$ unless this is a reboot
		if (title == undefined) {
			//-- 5.38.03.2019.07.21 change from 'Translate Error' to 'BLOX Total CMS Error'
			r = confirm("Continue? (" + versionLine_s + ")\n" + msg, true, "BLOX Total CMS Error: ", 469);
		}
		else {
			r = confirm("Continue? (" + versionLine_s + ")\n" + msg, true, title, 469);
		}
		//-- This next thing is a an attempt to limit crashes by 
		//--	keeping the redraw turned off.
		if ((!app.modalState) && app.scriptPreferences.enableRedraw) {
			msg = 'turning off redraw.';
			ll.iLog(reg, msg, true);
			app.scriptPreferences.enableRedraw = false;
		}
		if (r) {
			return (r);
		}
		else {
			//-- 4.21 had tried to exit the app, but that isn't an option
			return false;
		}
	}
	else {
		//-- 4.72.01.2013.09.12 add the version to these non-continue versions.
		//-- 5.38.03.2019.07.21 switch to a wider dialog using alert$
		//-- 5.38.06.2019.07.31 can't use alert$ unless this is a reboot
		if (title == undefined) {
			//-- 5.38.03.2019.07.21 change from 'Translate Error' to 'BLOX Total CMS Error'
			alert("Version (" + versionLine_s + ")\n" + msg, "BLOX Total CMS Error: ", true, 469);
		}
		else {
			alert("Version (" + versionLine_s + ")\n" + msg, title, true, 469);
		}
		//-- 4.21 had tried to exit the app, but that isn't an option
		//-- This next thing is a an attempt to limit crashes by 
		//--	keeping the redraw turned off.
		if ((!app.modalState) && app.scriptPreferences.enableRedraw) {
			msg = 'turning off redraw.';
			ll.iLog(reg, msg, true);
			app.scriptPreferences.enableRedraw = false;
		}
		return false;
	}
	//-- really stupid sanity check:
	//-- This next thing is a an attempt to limit crashes by 
	//--	keeping the redraw turned off.
	if ((!app.modalState) && app.scriptPreferences.enableRedraw) {
		msg = 'turning off redraw.';
		ll.iLog(reg, msg, true);
		app.scriptPreferences.enableRedraw = false;
	}
	return false;
} //-- End of function
//
//
function locateGeneralDocuments () {
	//-- This function created for version 4.31.14
	//-- create the object
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments = new Object();
	//-- set a flag
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.files = null;

	//-- define the folder
	//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
	//~ 	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/General Documents') ;
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/General Documents');
	//-- verify that it exists
	//-- 4.72.50.2014.02.03 if the legacy folder exists, us that. Else try 
	//--	new location and create instead of just verify. 

	if (!this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.exists) {
		//-- change the path and create the folder. 
		//-- 5.18.01-1.2017.02.15 INDESIGN-1566 redirect to rootOfAllOptionalItems_d
		//~ 		this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder (this.com.townnews.BLOXTotalCMS.resources.rootScriptPath.parent + '/General_Documents') ;
		this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder = new Folder(this.com.townnews.BLOXTotalCMS.resources.rootOfAllOptionalItems_d + '/General_Documents');
		if (!this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.verify()) {
			return null;
		}
	}
	//-- implied else
	//-- 4.40.8 change to the way 'getFiles' is used
	//-- 5.32.19.2018.07.10 INDESIGN-2273 sort the docs
	this.com.townnews.BLOXTotalCMS.resources.generalDocuments.files = this.com.townnews.BLOXTotalCMS.resources.generalDocuments.folder.getFilesWithSuffix('.pdf').sort(CIAscending);
}
//
//
//-- End of File